import { Navbar } from "@/components/layout/Navbar";
import { Footer } from "@/components/layout/Footer";
import { Button } from "@/components/ui/button";
import { Link } from "wouter";
import { ArrowRight, CheckCircle2, Factory, Zap, Target, Cpu, Code2, Database, LayoutTemplate } from "lucide-react";
import Autoplay from "embla-carousel-autoplay";
import useEmblaCarousel from "embla-carousel-react";
import heroBg1 from "@assets/generated_images/Background_img1.png";
import heroBg2 from "@assets/generated_images/Background_img2.png";
import heroBg3 from "@assets/generated_images/Background_img3.png";

export default function Home() {
  const [emblaRef] = useEmblaCarousel({ loop: true }, [Autoplay({ delay: 5000 })]);

  const slides = [
    {
      image: heroBg1,
      headline: "🚀 Automate Your Engineering — Work 5xFaster",
      subline: "Transform repetitive CAD tasks into intelligent, reusable automation workflows.",
    },
    {
      image: heroBg2,
      headline: "⚙️ Manual Modeling Is History — Automation Is the Future",
      subline: "Design smarter, scale faster, and stay competitive with automation-driven CAD development.",
    },
    {
      image: heroBg3,
      headline: "🎯 Engineering Efficiency Starts Here",
      subline: "Save time, reduce rework, and unlock the full potential of CAD customization.",
    },
  ];

  return (
    <div className="min-h-screen flex flex-col bg-background">
      <Navbar />
      
      {/* Hero Slider */}
      <section className="relative overflow-hidden bg-slate-900 text-white" ref={emblaRef}>
        <div className="flex">
          {slides.map((slide, index) => (
            <div key={index} className="relative flex-[0_0_100%] min-w-0 h-150 md:h-175">
              <div 
                className="absolute inset-0 z-0 opacity-40"
                style={{ 
                  backgroundImage: `url(${slide.image})`,
                  backgroundSize: 'cover',
                  backgroundPosition: 'center'
                }}
              />
              <div className="absolute inset-0 bg-linear-to-r from-slate-900 via-slate-900/80 to-transparent z-10" />*/
              
              <div className="container relative z-20 mx-auto px-4 h-full flex flex-col justify-center">
                <div className="max-w-4xl space-y-6 animate-in slide-in-from-left-10 duration-700 fade-in">
                  <h1 className="font-display text-4xl font-bold tracking-tight sm:text-6xl text-white leading-tight">
                    {slide.headline}
                  </h1>
                  <p className="text-xl text-slate-200 max-w-2xl leading-relaxed">
                    {slide.subline}
                  </p>
                  
                  <div className="flex flex-col sm:flex-row gap-4 pt-6">
                    {/* Here i have changed the get consultation button destination to a google form  */}
                    {/* <Link href="/services/https://forms.gle/7zrASYUa3JxVQxLK8">
                      <Button size="lg" className="h-14 px-8 text-lg bg-accent text-white hover:bg-accent/90 border-0 shadow-lg shadow-accent/20 cursor-pointer rounded-full">
                        Get Free Consultation <ArrowRight className="ml-2 h-5 w-5" />
                      </Button>
                    </Link> */}

                     <a href="https://forms.gle/7zrASYUa3JxVQxLK8" target="_blank" rel="noopener noreferrer">
                      <Button size="lg" className="h-14 px-8 text-lg bg-accent text-white hover:bg-accent/90 border-0 shadow-lg shadow-accent/20 cursor-pointer rounded-full">
                        Get Free Consultation <ArrowRight className="ml-2 h-5 w-5" />
                      </Button>
                     </a>
                    <Link href="/courses">
                      <Button size="lg" variant="outline" className="h-14 px-8 text-lg bg-transparent border-white/30 text-white hover:bg-white/10 hover:text-white cursor-pointer rounded-full backdrop-blur-sm">
                        View Our Training Programs
                      </Button>
                    </Link>
                  </div>
                </div>
              </div>
            </div>
          ))}
        </div>
      </section>

      {/* Tagline Section */}
      <section className="py-16 bg-primary text-white">
        <div className="container mx-auto px-4 text-center">
          <h2 className="font-display text-3xl md:text-4xl font-bold mb-6">Automation. Training. Innovation.</h2>
          <p className="text-xl text-slate-200 max-w-3xl mx-auto leading-relaxed">
            Empowering engineering teams and individuals to work smarter — not harder.
          </p>
          <div className="mt-8 flex flex-wrap justify-center gap-3">
             {["Creo ProToolkit", "NX Open", "SolidWorks API", "CATIA CAA", "AutoCAD Automation", "C++", "Python", "VB.NET"].map((tag) => (
               <span key={tag} className="px-4 py-2 bg-white/10 rounded-full text-sm font-medium border border-white/20">
                 {tag}
               </span>
             ))}
          </div>
        </div>
      </section>

      {/* What We Do Split */}
      <section className="py-24 bg-white">
        <div className="container mx-auto px-4">
          <div className="text-center mb-16">
             <h2 className="font-display text-3xl font-bold text-slate-900 mb-4">What We Do</h2>
             <p className="text-slate-600 max-w-2xl mx-auto">Cadivity helps engineers and organizations automate repetitive design workflows, develop custom CAD applications, and master engineering API programming.</p>
          </div>

          <div className="grid md:grid-cols-2 gap-12 lg:gap-24">
            {/* Services */}
            <div className="space-y-6 p-8 bg-slate-50 rounded-2xl border border-slate-100 hover:shadow-lg transition-shadow">
              <div className="h-14 w-14 rounded-xl bg-primary/10 flex items-center justify-center">
                <Factory className="h-7 w-7 text-primary" />
              </div>
              <h3 className="text-2xl font-display font-bold text-slate-900">Custom Automation Services</h3>
              <p className="text-lg text-slate-600 leading-relaxed">
                We build custom software solutions to automate your design workflows. From simple macros to complex enterprise plugins.
              </p>
              <ul className="space-y-3">
                {['Drawing & Model Automation', 'Custom Plugin Development', 'ERP Integration', 'Batch Processing'].map((item) => (
                  <li key={item} className="flex items-center text-slate-700">
                    <CheckCircle2 className="h-5 w-5 text-accent mr-3" />
                    {item}
                  </li>
                ))}
              </ul>
              <Link href="/services">
                <Button className="w-full mt-4 bg-primary text-white hover:bg-primary/90">
                  Explore Services
                </Button>
              </Link>
            </div>

            {/* Training */}
            <div className="space-y-6 p-8 bg-slate-50 rounded-2xl border border-slate-100 hover:shadow-lg transition-shadow">
              <div className="h-14 w-14 rounded-xl bg-accent/10 flex items-center justify-center">
                <Target className="h-7 w-7 text-accent" />
              </div>
              <h3 className="text-2xl font-display font-bold text-slate-900">Professional Training</h3>
              <p className="text-lg text-slate-600 leading-relaxed">
                Master the skills that the industry demands. Practical, project-based courses on CAD API programming.
              </p>
              <ul className="space-y-3">
                {['Creo ProToolkit & C++', 'SolidWorks API (C# / VB.NET)', 'NX Open Programming', 'Corporate Training'].map((item) => (
                  <li key={item} className="flex items-center text-slate-700">
                    <CheckCircle2 className="h-5 w-5 text-primary mr-3" />
                    {item}
                  </li>
                ))}
              </ul>
              <Link href="/courses">
                <Button variant="outline" className="w-full mt-4 border-primary text-primary hover:bg-primary/5">
                  View Courses
                </Button>
              </Link>
            </div>
          </div>
        </div>
      </section>

      <Footer />
    </div>
  );
}
